#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Shane's Noise_but auto tiledMod01.fsh  by   DEKTEN
//https://www.shadertoy.com/view/ssSXWm
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


//: A copy of shane's "Smooth Noise Countours" with auto tiling math applied to it.
//: Pages through the 16 possible sub-tiles of an auto tile sets and maps shanes
//: shader onto the tile. The screen being the coordinate space of the tile.
//:
//: You can use this kind of math to create procedural auto tiling.
//:
//: Shane's original shader: https://www.shadertoy.com/view/ldscWH
//: 
//: My twitch coding stream: www.twitch.com/kanjicoder


// Variable to a keep a copy of the noise value prior to palettization. Used to run a soft gradient 
// over the surface, just to break things up a little.
float ns;


//float sFract(float x, float sm){ float fx = fract(x); return fx - smoothstep(fwidth(x)*sm, 0., 1. - fx); }
//float sFract(float x, float sm){ float fx = fract(x); return min(fx, fx*(1. - fx)/fwidth(x)/sm); }

// Based on Ollj's smooth "fract" formula.
float sFract(float x, float sm){
    
    // Extra smoothing factor. "1" is the norm.
    const float sf = 1.; 
    
    // The hardware "fwidth" is cheap, but you could take the expensive route and
    // calculate it by hand if more quality was required.
    vec2 u = vec2(x, fwidth(x)*sf*sm);
    
    // Ollj's original formula with a transcendental term omitted.
    u.x = fract(u.x);
    u += (1. - 2.*u)*step(u.y, u.x);
    return clamp(1. - u.x/u.y, 0., 1.); // Cos term ommitted.
}



// Only correct for nonnegative values, but in this example, numbers aren't negative.
float sFloor(float x){ return x - sFract(x, 1.); } 

// Standard hue rotation formula with a bit of streamlining. 
vec3 rotHue(vec3 p, float a){

    vec2 cs = sin(vec2(1.570796, 0) + a);

    mat3 hr = mat3(0.299,  0.587,  0.114,  0.299,  0.587,  0.114,  0.299,  0.587,  0.114) +
        	  mat3(0.701, -0.587, -0.114, -0.299,  0.413, -0.114, -0.300, -0.588,  0.886) * cs.x +
        	  mat3(0.168,  0.330, -0.497, -0.328,  0.035,  0.292,  1.250, -1.050, -0.203) * cs.y;
							 
    return clamp(p*hr, 0., 1.);
}



// vec3 to vec3 hash algorithm.
vec3 hash33(vec3 p) { 

    // Faster, but doesn't disperse things quite as nicely as the block below it. However, when framerate
    // is an issue, and it often is, this is the one to use. Basically, it's a tweaked amalgamation I put
    // together, based on a couple of other random algorithms I've seen around... so use it with caution,
    // because I make a tonne of mistakes. :)
    float n = sin(dot(p, vec3(7, 157, 113)));    
    return fract(vec3(2097152, 262144, 32768)*n)*2. - 1.; // return fract(vec3(64, 8, 1)*32768.0*n)*2.-1.; 

    // I'll assume the following came from IQ.
    //p = vec3( dot(p, vec3(127.1, 311.7, 74.7)), dot(p, vec3(269.5, 183.3, 246.1)), dot(p, vec3(113.5, 271.9, 124.6)));
    //return (fract(sin(p)*43758.5453)*2. - 1.);

}



// Cheap, streamlined 3D Simplex noise... of sorts. I cut a few corners, so it's not perfect, but it's
// artifact free and does the job. I gave it a different name, so that it wouldn't be mistaken for
// the real thing.
// 
// Credits: Ken Perlin, the inventor of Simplex noise, of course. Stefan Gustavson's paper - 
// "Simplex Noise Demystified," IQ, other "ShaderToy.com" people, etc.
float tetraNoise(in vec3 p)
{
    // Skewing the cubic grid, then determining the first vertice and fractional position.
    vec3 i = floor(p + dot(p, vec3(.333333)) );  p -= i - dot(i, vec3(.166666)) ;
    
    // Breaking the skewed cube into tetrahedra with partitioning planes, then determining which side of the 
    // intersecting planes the skewed point is on. Ie: Determining which tetrahedron the point is in.
    vec3 i1 = step(p.yzx, p), i2 = max(i1, 1. - i1.zxy); i1 = min(i1, 1. - i1.zxy);    
    
    // Using the above to calculate the other three vertices -- Now we have all four tetrahedral vertices.
    // Technically, these are the vectors from "p" to the vertices, but you know what I mean. :)
    vec3 p1 = p - i1 + .166666, p2 = p - i2 + .333333, p3 = p - .5;
  

    // 3D simplex falloff - based on the squared distance from the fractional position "p" within the 
    // tetrahedron to the four vertice points of the tetrahedron. 
    vec4 v = max(.5 - vec4(dot(p, p), dot(p1, p1), dot(p2, p2), dot(p3, p3)), 0.);
    
    // Dotting the fractional position with a random vector, generated for each corner, in order to determine 
    // the weighted contribution distribution... Kind of. Just for the record, you can do a non-gradient, value 
    // version that works almost as well.
    vec4 d = vec4(dot(p, hash33(i)), dot(p1, hash33(i + i1)), dot(p2, hash33(i + i2)), dot(p3, hash33(i + 1.)));
     
     
    // Simplex noise... Not really, but close enough. :)
    return clamp(dot(d, v*v*v*8.)*1.732 + .5, 0., 1.); // Not sure if clamping is necessary. Might be overkill.

}


// The function value. In this case, slightly-tapered, quantized Simplex noise.
float func(vec2 p){
    
    // The noise value.
    float n = tetraNoise(vec3(p.x*4., p.y*4., 0) - vec3(0, .25, .5)*iTime);
    
    // A tapering function, similar in principle to a smooth combine. Used to mutate or shape 
    // the value above. This one tapers it off into an oval shape and punches in a few extra holes.
    // Airtight uses a more interesting triangular version in his "Cartoon Fire" shader.
    float taper = .1 + dot(p, p*vec2(.35, 1));
	n = max(n - taper, 0.)/max(1. - taper, .0001);
    
    // Saving the noise value prior to palettization. Used for a bit of gradient highlighting.
    ns = n; 
    
    // I remember reasoning to myself that the following would take a continuous function ranging
    // from zero to one, then palettize it over "palNum" discreet values between zero and one
    // inclusive. It seems to work, but if my logic is lacking (and it often is), feel free to 
    // let me know. :)
    const float palNum = 9.; 
    // The range should strictly fall between zero and one, but for some crazy reason, numbers fall
    // outside the range, so I've had to clamp it. I know the computer is never wrong, so I'm 
    // probably overlooking something. Having said that, I don't trust the GPU "fract" function much.
    //return clamp(sFloor(n*(palNum - .001))/(palNum - 1.), 0., 1.);
    return n*.25 + clamp(sFloor(n*(palNum - .001))/(palNum - 1.), 0., 1.)*.75;
    
}

vec2 getSubTileCoords( vec2 f_c ){

    //: Pretend the entire screen is one tile for this  -----://
    //: example code. Center is at [0,0] , top left is  -----://
    //: at [-1,-1] and bottom right is at [+1,+1]       -----://
    vec2 uvc   = (f_c -0.5*iResolution.xy)/iResolution.y;
         uvc.y =( 0.0 - uvc.y ); //:Invert Y axis

//+----------------------------------------------------------+//
//| What is the current wang-tile touching mask for          |//
//| the tile you are drawing. In this example,               |//
//| pretend the entire screen is one tile.                   |//
//| TIL == Your One Tile                                     |//
//|          +---+                                           |//
//|          |y_0|                                           |//
//|      +---+---+---+      0|1  0|1  |  0|1  0|1            |//
//|      |x_0|TIL|x_1| -->  ___  ___  |  ___  ___            |//
//|      +---+---+---+      X_0  X_1  |  Y_0  Y_1            |//
//|          |y_1|                                           |//
//|          +---+                                           |//
//|                                                          |//
//| toutang means : Touching Tangent                         |//
//|                                                          |//
//| [-1,-1]                                                  |//
//|     +-------------+                                      |//
//|     |             |                                      |//
//|     |             |                                      |//
//|     |     0.0     | <--[ TIL ] www.twitch.com/kanjicoder |//
//|     |             |                                      |//
//|     |             |                                      |//
//|     +-------------+                                      |//
//|                 [+1,+1]                                  |//
//|                                                          |//
//+----------------------------------------------------------+//

    //:Animate the touching value of your tile.         -----://
    //:Emulating all different combinations of which    -----://
    //:neighbors can exist above,below,left,and right:  -----://

    uint toutang=(uint(int(mod(iTime,16.0))));

//+----------------------------------------------------------+//
//|   +-----------------+ If( touself ==BINARY[ 1000 ] )THEN:|//
//|   |\\     y_0     //|                                    |//
//|   |  \\         //  |   We are in the x_0 pie slice.     |//
//|   |    \\     //    |                                    |//
//|   |      \\ //      | If( touself ==BINARY[ 1010 ] )THEN:|//
//|   |x_0  ( 0.0 )  x_1|                                    |//
//|   |      // \\      |   I fucked up the formula because  |//
//|   |    //     \\    |   only ONE_BIT in touself should   |//
//|   |  //         \\  |   have been set.                   |//
//|   |//     y_1     \\|                                    |//
//|   +-----------------+                                    |//
//|   BITS[  0   0   0   0  ]                                |//
//|   SIDE[ x_0 x_1 y_0 y_1 ]     www.twitch.com/kanjicoder  |//
//|                                                          |//
//|   touself means: "TOUching SELF"                         |//
//+----------------------------------------------------------+//

    //:Figure out which pie slice the pixel of  -------------://
    //:your tile belongs to and set that bit:   -------------://
    #define A abs
    #define U uint
    #define X uvc.x
    #define Y uvc.y
    U touself =( U(0)
    | (( (X <= 0.0 && (A(X)>A(Y))) ? U(1) : U(0) ) << 3)
    | (( (X >= 0.0 && (A(X)>A(Y))) ? U(1) : U(0) ) << 2)
    | (( (Y <= 0.0 && (A(Y)>A(X))) ? U(1) : U(0) ) << 1)
    | (( (Y >= 0.0 && (A(Y)>A(X))) ? U(1) : U(0) ) << 0)
    );;
    #undef A
    #undef U
    #undef X
    #undef Y

    //:If we are on a pie slice that is touching a           ://
    //:neighbor, use the connected gradient(congrad).        ://
    //:If we are on a pie slice that is __NOT__              ://
    //:touching a neighbor, use walled-off gradient(walgrad).://
    float walgrad = float( max( abs(uvc.x),abs(uvc.y) ) );
    float congrad = float( min( abs(uvc.x),abs(uvc.y) ) );
    float tougrad = (( touself & toutang )>=uint(1)) 
                 ? congrad   //:TRUE : Connected  Gradient
                 : walgrad ; //:FALSE: Walled Off Gradient

    float invgrad = (( touself & toutang )>=uint(1)) 
                 ? walgrad   //:INVERTED_GRADIENT
                 : congrad ; //:INVERTED_GRADIENT

    return( vec2( tougrad , invgrad ) );

} //:[getSubTileCoords]:<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<://


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{

    // Screen coordinates.
	vec2 u = getSubTileCoords( fragCoord );
    
    // Function value.
    float f = func(u);
    float ssd = ns; // Saving the unpalettized noise value to add a little gradient to the color, etc.
    
    // Four sample values around the original. Used for edging and highlighting.
    vec2 e = vec2(1.5/iResolution.y, 0);
    float fxl = func(u + e.xy);
    float fxr = func(u - e.xy);
    float fyt = func(u + e.yx);
    float fyb = func(u - e.yx);
    
    // Colorizing the function value, and applying some hue rotation based on position.
    // Most of it was made up.
    vec3 col = pow(min(vec3(1.5, 1, 1)*(f*.7 + ssd*.35), 1.), vec3(1, 2., 10)*2.) + .01;
    col = rotHue(col, -.25+.4*length(u));

    // Applying the dark edges.
    col *= max(1. - (abs(fxl - fxr) + abs(fyt - fyb))*5., 0.);
    //col *= max(1. - length(vec2(fxl, fyt) - vec2(fxr, fyb))*7., 0.);
    // Resampling with a slightly larger spread to provide some highlighting.
    fxl = func(u + e.xy*1.5);
    fyt = func(u + e.yx*1.5);
    col += vec3(.5, .7, 1)*(max(f - fyt, 0.) + max(f - fxl, 0.))*ssd*10.;
    
    // Subtle, bluish vignette.
    //u = fragCoord/iResolution.xy;
    //col = mix(vec3(0, .1, 1), col, pow( 16.0*u.x*u.y*(1.0-u.x)*(1.0-u.y) , .125)*.15 + .85);

 	
    // Rough gamma correction.
    fragColor = vec4(sqrt(clamp(col, 0., 1.)), 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

